/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.impl.ChampionsApiImpl;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.server.command.AffixArgument;

public class ChampionsCommand {
    public static final SuggestionProvider<CommandSourceStack> AFFIXES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("champions", "affices"), (context, builder) -> SharedSuggestionProvider.m_82981_(ChampionsApiImpl.getInstance().getAffixes().stream().map(IAffix::getIdentifier), (SuggestionsBuilder)builder));
    public static final SuggestionProvider<CommandSourceStack> MONSTER_ENTITIES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("champions", "monster_entities"), (context, builder) -> SharedSuggestionProvider.m_82960_(ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.m_20674_() == MobCategory.MONSTER), (SuggestionsBuilder)builder, EntityType::m_20613_, type -> new TranslatableComponent(Util.m_137492_((String)"entity", (ResourceLocation)EntityType.m_20613_((EntityType)type)))));
    private static final DynamicCommandExceptionType UNKNOWN_ENTITY = new DynamicCommandExceptionType(type -> new TranslatableComponent("command.champions.egg.unknown_entity", new Object[]{type}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder championsCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"champions").requires(player -> player.m_6761_(2));
        championsCommand.then(Commands.m_82127_((String)"egg").then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgument.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.m_82127_((String)"summon").then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgument.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.m_82127_((String)"summonpos").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.m_174395_((CommandContext)context, (String)"pos"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgument.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.m_174395_((CommandContext)context, (String)"pos"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSourceStack>)context, "affixes"))))))));
        dispatcher.register(championsCommand);
    }

    private static int summon(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        return ChampionsCommand.summon(source, null, resourceLocation, tier, affixes);
    }

    private static int summon(CommandSourceStack source, @Nullable BlockPos pos, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        Entity entity;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
        if (entityType == null) {
            throw UNKNOWN_ENTITY.create((Object)resourceLocation);
        }
        Entity sourceEntity = source.m_81373_();
        if (sourceEntity != null && (entity = entityType.m_20655_((ServerLevel)sourceEntity.m_183503_(), null, null, null, pos != null ? pos : new BlockPos((Vec3i)sourceEntity.m_142538_()), MobSpawnType.COMMAND, false, false)) instanceof LivingEntity) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> ChampionBuilder.spawnPreset(champion, tier, new ArrayList<IAffix>(affixes)));
            source.m_81372_().m_7967_(entity);
            source.m_81354_((Component)new TranslatableComponent("commands.champions.summon.success", new Object[]{new TranslatableComponent("rank.champions.title." + tier).getString() + " " + entity.m_5446_().getString()}), false);
        }
        return 1;
    }

    private static int createEgg(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
        if (entity == null) {
            throw UNKNOWN_ENTITY.create((Object)resourceLocation);
        }
        Entity entity2 = source.m_81373_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entity2;
            ItemStack egg = new ItemStack((ItemLike)ChampionsRegistry.EGG);
            ChampionEggItem.write(egg, resourceLocation, tier, affixes);
            ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)egg, (int)1);
            source.m_81354_((Component)new TranslatableComponent("commands.champions.egg.success", new Object[]{egg.m_41611_()}), false);
        }
        return 1;
    }
}

